/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.genlayers.river;

import net.dries007.tfc.world.classic.genlayers.GenLayerTFC;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerRiverMixTFC
extends GenLayerTFC {
    private final GenLayer biomePatternGeneratorChain;
    private final GenLayer riverPatternGeneratorChain;
    private int[] layerBiomes;
    private int[] layerRivers;
    private int[] layerOut;
    private int xn;
    private int xp;
    private int zn;
    private int zp;

    public GenLayerRiverMixTFC(long par1, GenLayer par3GenLayer, GenLayer par4GenLayer) {
        super(par1);
        this.biomePatternGeneratorChain = par3GenLayer;
        this.riverPatternGeneratorChain = par4GenLayer;
    }

    public void removeRiver(int index, int biomeToReplaceWith) {
        if (this.layerOut[index] == this.riverID) {
            if (this.xn >= 0 && this.layerBiomes[this.xn] == biomeToReplaceWith) {
                this.layerOut[index] = biomeToReplaceWith;
            }
            if (this.zn >= 0 && this.layerBiomes[this.zn] == biomeToReplaceWith) {
                this.layerOut[index] = biomeToReplaceWith;
            }
            if (this.xp < this.layerBiomes.length && this.layerBiomes[this.xp] == biomeToReplaceWith) {
                this.layerOut[index] = biomeToReplaceWith;
            }
            if (this.zp < this.layerBiomes.length && this.layerBiomes[this.zp] == biomeToReplaceWith) {
                this.layerOut[index] = biomeToReplaceWith;
            }
        }
    }

    public boolean inBounds(int index, int[] array) {
        return index < array.length && index >= 0;
    }

    public void func_75905_a(long par1) {
        this.biomePatternGeneratorChain.func_75905_a(par1);
        this.riverPatternGeneratorChain.func_75905_a(par1);
        super.func_75905_a(par1);
    }

    public int[] func_75904_a(int x, int z, int xSize, int zSize) {
        this.layerBiomes = this.biomePatternGeneratorChain.func_75904_a(x, z, xSize, zSize);
        this.layerRivers = this.riverPatternGeneratorChain.func_75904_a(x, z, xSize, zSize);
        this.layerOut = IntCache.func_76445_a((int)(xSize * zSize));
        for (int zElement = 0; zElement < zSize; ++zElement) {
            for (int xElement = 0; xElement < xSize; ++xElement) {
                int index = xElement + zElement * xSize;
                int b = this.layerBiomes[index];
                this.xn = index - 1;
                this.xp = index + 1;
                this.zn = index - zSize;
                this.zp = index + zSize;
                if (this.isOceanicBiome(b)) {
                    this.layerOut[index] = b;
                } else if (this.layerRivers[index] == this.riverID) {
                    this.layerOut[index] = this.riverID;
                    if (this.isBeachBiome(b)) {
                        this.layerOut[index] = this.oceanID;
                        if (this.inBounds(this.xn, this.layerOut) && this.layerOut[this.xn] == this.riverID) {
                            this.layerOut[this.xn] = this.oceanID;
                        }
                        if (this.inBounds(this.zn, this.layerOut) && this.layerOut[this.zn] == this.riverID) {
                            this.layerOut[this.zn] = this.oceanID;
                        }
                        if (this.inBounds(this.zp, this.layerOut) && this.isOceanicBiome(this.layerBiomes[this.zp]) && this.layerRivers[this.zp] == 0) {
                            this.layerOut[index] = b;
                        }
                        if (this.inBounds(this.zn, this.layerOut) && this.isOceanicBiome(this.layerBiomes[this.zn]) && this.layerRivers[this.zn] == 0) {
                            this.layerOut[index] = b;
                        }
                        if (this.inBounds(this.xn, this.layerOut) && this.isOceanicBiome(this.layerBiomes[this.xn]) && this.layerRivers[this.xn] == 0) {
                            this.layerOut[index] = b;
                        }
                        if (this.inBounds(this.xp, this.layerOut) && this.isOceanicBiome(this.layerBiomes[this.xp]) && this.layerRivers[this.xp] == 0) {
                            this.layerOut[index] = b;
                        }
                    }
                } else {
                    this.layerOut[index] = b;
                }
                this.removeRiver(index, this.lakeID);
                this.removeRiver(index, this.mountainsEdgeID);
            }
        }
        return (int[])this.layerOut.clone();
    }
}

